/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: $:

  Description:
    Definition file of the RS232 Connector configuration functions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2019-12-09  Update file header to actual version
    2009-11-27  Review
    2009-08-09  created

**************************************************************************************/

/*****************************************************************************/
/*! \file RS232Config.h
*   Definition file of the RS232 Connector configuration functions           */
/*****************************************************************************/

/* prevent multiple inclusion */
#pragma once

#include "ConnectorConfig.h"
#include "netXConnectorErrors.h"

/*****************************************************************************/
/*! \addtogroup netX_CONNECTOR_RS232 netX RS232 Connector                    */
/*! \{                                                                       */
/*****************************************************************************/

extern const UUID g_tConnectorUUID;

#define NXCON_RS232KEY_BAUDRATE "BAUDRATE"  /*!< Configuration key to adjust the baudrate of the serial interface */
#define NXCON_RS232KEY_BYTESIZE "BYTESIZE"  /*!< Configuration key to adjust the bytesize of the serial interface */
#define NXCON_RS232KEY_PARITY   "PARITY"    /*!< Configuration key to adjust the parity of the serial interface   */
#define NXCON_RS232KEY_STOPBITS "STOPBITS"  /*!< Configuration key to adjust the stopbits of the serial interface */

///////////////////////////////////////////////////////////////////////////////////////////
/// \class CRS232Config
/// Device Property Page class
///////////////////////////////////////////////////////////////////////////////////////////
class CRS232Config:public CConnectorConfig
{
public:
  // Constructor
  CRS232Config( BOOL fLoadFormRegistry = FALSE);

  // Copy Constructor
  CRS232Config( const CRS232Config& cRS232Config) {*this = cRS232Config;}

  // Destructor
	~CRS232Config();

  // Assignment operator
  CRS232Config& operator= ( const CRS232Config& cCRS232Config) {CConnectorConfig::operator=( cCRS232Config); return *this;}

  ///////////////////////////////////////////////////////////////////////////////////////////
  /// Iterate over configured RS232 interfaces
  ///////////////////////////////////////////////////////////////////////////////////////////
  class iterator:public CConnectorConfig::iterator
  {
  public:
    // Constructor
    iterator(INTFCONFIG_MAP::iterator iterIntf)
    :CConnectorConfig::iterator(iterIntf)
    {
    }

    // Copy Constructor
    iterator(const CConnectorConfig::iterator& iterConfig)
    :CConnectorConfig::iterator(iterConfig)
    {
    }

    /////////////////////////////////////////////////////////////////////////////
    /// Returns interface baudrate
    /// \return Interface baudrate
    /////////////////////////////////////////////////////////////////////////////
    DWORD GetBaudRate ( void)
    {
      DWORD dwRet = CBR_115200;

      /* Search for baudrate config key */
      CONFIGKEY_MAP::iterator iterKey = m_iterIntf->second.find( NXCON_RS232KEY_BAUDRATE);
      if (m_iterIntf->second.end() != iterKey)
      {
        dwRet = atoi(iterKey->second);
      }

      return dwRet;
    }
    /////////////////////////////////////////////////////////////////////////////
    /// Returns interface bytesize
    /// \return Interface bytesize
    /////////////////////////////////////////////////////////////////////////////
    BYTE GetByteSize ( void)
    {
      BYTE bRet = 8;

      /* Search for bytesize config key */
      CONFIGKEY_MAP::iterator iterKey = m_iterIntf->second.find( NXCON_RS232KEY_BYTESIZE);
      if (m_iterIntf->second.end() != iterKey)
      {
        bRet  = (BYTE)atoi(iterKey->second);
      }

      return bRet;
    }

    /////////////////////////////////////////////////////////////////////////////
    /// Returns interface parity
    /// \return Interface parity
    /////////////////////////////////////////////////////////////////////////////
    BYTE GetParity ( void)
    {
      BYTE bRet = NOPARITY;

      /* Search for parity config key */
      CONFIGKEY_MAP::iterator iterKey = m_iterIntf->second.find( NXCON_RS232KEY_PARITY);
      if (m_iterIntf->second.end() != iterKey)
      {
        bRet  = (BYTE)atoi(iterKey->second);
      }

      return bRet;
    }
    /////////////////////////////////////////////////////////////////////////////
    /// Returns interface stopbits
    /// \return Interface stoppbits
    /////////////////////////////////////////////////////////////////////////////
    BYTE GetStopBits ( void)
    {
      BYTE bRet = ONESTOPBIT;

      /* Search for stopbits config key */
      CONFIGKEY_MAP::iterator iterKey = m_iterIntf->second.find( NXCON_RS232KEY_STOPBITS);
      if (m_iterIntf->second.end() != iterKey)
      {
        bRet  = (BYTE)atoi(iterKey->second);
      }

      return bRet;
    }
  };
};

/*****************************************************************************/
/*! \}                                                                       */
/*****************************************************************************/

extern CRS232Config g_cRS232Config;
